from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class ForgetfulGrudger(Player):
    """
    A player starts by cooperating however will defect if at any point the
    opponent has defected, but forgets after mem_length matches.

    Names:

    - Forgetful Grudger: Original name by Geraint Palmer
    """

    name = "Forgetful Grudger"
    classifier = {
        "memory_depth": 10,
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def __init__(self) -> None:
        """Initialised the player."""
        super().__init__()
        self.mem_length = 10
        self.grudged = False
        self.grudge_memory = 0

    def strategy(self, opponent: Player) -> Action:
        """Begins by playing C, then plays D for mem_length rounds if the
        opponent ever plays D."""
        if self.grudge_memory == self.mem_length:
            self.grudge_memory = 0
            self.grudged = False

        if D in opponent.history[-1:]:
            self.grudged = True

        if self.grudged:
            self.grudge_memory += 1
            return D
        return C